/* ============ */
/* srlchisq.c	*/
/* ============ */
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <miscdefs.h>
#include <serldefs.h>
#include <assert.h>

extern	UINT	WorkArea[];
/* ================================================================= */
/* CalcSerialChiSq - Calculates Chi-Square Statistic for Serial Test */
/* ================================================================= */
void
CalcSerialChiSq(SERIAL_DATA_STRU  *SerialData)
{
    long    k;
    double  SumSq = 0;

    memset(WorkArea, 0, sizeof(UINT) * SerialData->NumCategories);

    for (k = 0; k < SerialData->UserNumPairs; ++k)
    {
	int	x, y;
	long	p;

	/* ---------------- */
	/* Next Observation */
	/* ---------------- */
	x = SerialData->RandFun() % SerialData->SetSize;
	y = SerialData->RandFun() % SerialData->SetSize;

	p = x * SerialData->SetSize + y;
	assert(p < (long)SerialData->NumCategories);
	++WorkArea[p];
    }

    /* ------------------------ */
    /* Accumulate Variate Count */
    /* ------------------------ */
    SerialData->TotNumGen += 2 * SerialData->UserNumPairs;

    /* -------------------------------------- */
    /* Calculate Sum of Squares of Categories */
    /* -------------------------------------- */
    for (k = 0; k < SerialData->NumCategories; ++k)
    {
	SumSq += SQR((double)WorkArea[k]);
    }

    /* ------------------------------ */
    /* Calculate Chi-Square Statistic */
    /* ------------------------------ */
    {
	double	Coef;

	Coef = (double)SerialData->NumCategories /
			(double)SerialData->UserNumPairs;

	SerialData->SerialChiSq =
	    Coef * SumSq - (double)SerialData->UserNumPairs;
    }
}
